"""
SeqMaster Runtime - Centralized Constants
Configurable timeouts and limits in one place.
"""

# Operator interaction (seconds)
OPERATOR_RESPONSE_SEC = 300  # 5 minutes for operator to respond
OPERATOR_POLL_SEC = 0.5  # How often to check for operator response

# Driver timeouts (milliseconds)
SCPI_TIMEOUT_MS = 5000

# Watchdog (milliseconds)
WATCHDOG_THROTTLE_MS = 500  # Min time between state saves

# UI updates (milliseconds)
STATUS_UPDATE_MS = 500  # WebSocket status update interval

# Limits
MAX_NESTING_DEPTH = 50  # Max IF/LOOP nesting

# Flow control step types (exclude from analytics)
# Also includes non-measurement steps like delay
FLOW_CONTROL_TYPES = {
	'label', 'goto', 'statement', 'if', 'else', 'else_if',
	'end_if', 'while', 'for_each', 'end_loop', 'break',
	'continue', 'message', 'delay'
}
