#!/bin/bash
# SeqMaster Uninstaller
set -e

if [ "$EUID" -ne 0 ]; then
    echo "Error: Run with sudo"
    exit 1
fi

echo "Removing SeqMaster..."

systemctl stop seqmaster 2>/dev/null || true
systemctl disable seqmaster 2>/dev/null || true
rm -f /etc/systemd/system/seqmaster.service
rm -f /etc/nginx/sites-enabled/seqmaster
rm -f /etc/nginx/sites-available/seqmaster
systemctl daemon-reload
systemctl restart nginx 2>/dev/null || true

read -p "Remove all files from /opt/seqmaster? (y/N) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    rm -rf /opt/seqmaster
    echo "Files removed."
fi

echo "SeqMaster uninstalled."
